﻿using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace IndianHealthService.BMXNet.Tests.ContextModelTests
{
    [TestFixture]
    public class KeyTests : BmxValidUserTestSuite
    {
        [Test]
        public void GetKeysAndVerify()
        {
            IndianHealthService.BMXNet.Model.User user = this.Framework.Context.User;

            List<string> keys = user.RequestKeys();

            foreach (string key in keys)
            {
                Assert.IsTrue(user.HasSecurityKey(key));
            }

            Assert.IsFalse(user.HasSecurityKey("BMXTEST NOT A KEY"));           
        }
    }
}